C	program m6inputa
C	10x period speeds and vmt read from file; 
C	speed bins are calculated for 24 hours
C	and then written to M6 speed definition files
C	vmt distribution is similarly calculated and written into
C	M6 hourly vmt distribution files
	Dimension spdbin(14),binfrac(24,14),speed(8,5,10),vdomain(5)
	Dimension vmt(8,5,10),spdav(8,5,3),ihalfs(48),vehmix(5,16)
	dimension hrspd(5,24),vmthr(8,5,24),vmtfrac(24),vmtot(24)
	Character*40 area(5),rdcls(8),fnam,fnamout
	dimension NUM_HALFS(10),halfs(48),tfvmt(24),imix(16)
	dimension itemp(24),frac(24),spdfc(2,24),facvmt(4,24)
	CHARACTER * 18 SPDCLASS(8)
	CHARACTER * 4 APER(3),facdef(8),VERSION,ayr
        CHARACTER * 20 FILOUT,header
	DATA AREA/'cbd','frn','urb','sub','rur'/
	DATA FACDEF/'fwy','fwy','art','art','art','rmp','art','loc'/
	DATA SPDCLASS/'fwy','exy','pra','mia','col','rmp','frn','loc'/
C ihalfs variable: assigns which of the 10 peak periods a specific half
C hour belongs to
	data area/'cbd','frn','urb','sub','rur'/
	data rdcls/'fwy','exy','pra','mia','col','rmp','frn','loc'/
	data spdbin/2.5,5.,10.,15.,20.,25.,30.,35.,40.,45.,50.,55.,60.,65/
C get calendar year
C open file for m6 scenarios
	open(8,file='m6scen.txt')
C open the vehicle mix file and read mixes 
	open(10,file='vmt/vehmix.def')
	read(10,*)((vehmix(ia,ivt),ivt=1,16),ia=1,5)
	close(10)
 37	format('VMT FRACTIONS      : ',2(/8(f6.4,x)))
C	
C******Calculate the 'halfs' variable from DRCOG TOD spreadsheet
C
C halfs variable: 48 half hour segments to define 24 hours (starts at
C midnight). See ../drcog/aa25/aa25todf.xls from DRCOG. This xls file is 
C ordered from least congested to most congested. Periods AM2 and  AM3
C are the most congested and each represent one half hour period. Conse-
C quently, the half variable value=1.00 for each of the 10 peak periods. 
C Halfs variable is calculated by
C dividing each half hour contribution by the total of the peak period it
C belongs to.   
C	
C*******Calculation of halfs variable from DRCOG TOD information:
C
C	input data for this program is derived from the DRCOG time-of-
C	day files. First input line describes the number of half hours
C	that make up each of the 10 peak periods (op1...am3)and
C	48 lines containing the fraction that half hour 
C	represents of that peak period (i.e., sum of Off Peak half hour
C	equals 1.00, etc) and the location of that half hour (itod_index)
C	in the 48 half hours in the day. The data is ordered from the least
C	congested half hour (off peak period 1; first data line) to 
C	the most congested half hour (am peak period 3, 48th data line)
C
C*******variable definition 
C	num_halfs = number of half hour periods in each of 10 periods
C	halfs = sum of halfs = 10.0; how the half hours contribute to the
C		whole of that period 
C 	itod_index = location of half period in 24 hours(1=0:00-0:30,
C	48=23:30-24:00)
C	halfs 
C 	ihalfs = location of that half hour period in the 48 halves of the day	
C	
C tod.in has the network specific parameters in it
	open(1,file='tod.in')
	read(1,11)ayr,version
c	print *,ayr,version
 11	format(a4,x,a2)
	read(1,*)(num_halfs(ip),ip=1,10)
c	print *,(num_halfs(ip),ip=1,10)
	ipd = 0
	do ip = 1,10
	    sum_halfs = 0. 
	    nhalfs = num_halfs(ip)
	    gtot = 0.0
C sum up the half hour contribution to the total of the 10 pp's
C note: sum of op1,op2,op3+op4 = 1.,sum of pm1,pm2,pm3=1., etc. 
C after below process, the sum of the half hours that contribute to each of
C the 10 peak periods sums to one. 
	    do nh = 1,nhalfs		!read all the half hours for this pkpd
	    	read(1,*)ipx,itod,xfrac
	    	ihalfs(itod) = ipx
C the arrays frac and itemp are temporary to store this half hour value
C for this pkpd	
	    	frac(nh) = xfrac !half hour contrib to am, pm or op
	    	itemp(nh)=itod	!where the half hour belongs in 48 half hours 
C sum the contributions of this period   	
	    	sum_halfs = sum_halfs + xfrac
	    end do
C normalize to each halfs contribution to the peak period so the total
C of the fractional contributions = 1.00
	    do nh = 1,nhalfs
	   	ip48 = itemp(nh)
	    	halfs(ip48) = frac(nh)/sum_halfs
	    	gtot = gtot + halfs(ip48)
	    end do	! end for normalizing
CP	    print *,'peak period ',ipx,' normalized to ',gtot
	end do
	do ihr = 1,24
cp	print 73,ihr,ihalfs(ihr*2-1),halfs(ihr*2-1),ihalfs(ihr*2),
cp     x		halfs(ihr*2)
	end do
 73	format(i5,2(i5,f10.4))
 30	format(3f10.4)
C
C****** Process the speed and vmt files
C	1. Read file containing the speed and VMT as f(at,fc,ip)
	open(2,file='vmtx400.txt')
	do iline = 1,400
	read(2,*,end=100)irec,ifc,ia,ip,spd,vmtx
	    ip = ip + 1
	    speed(ifc,ia,ip) = spd
	    vmt(ifc,ia,ip) = vmtx
	    vmttot = vmttot + vmt(ifc,ia,ip)
	end do
 100	continue
CP 	print 40,(((speed(ifc,ia,ip),ifc=1,8),ia=1,5),ip=1,10)
 40	format(8f6.2)
	print *,'VMT total after file read = '
	print 10,vmttot
 10	format (5f12.1)
	vmtotx = 0.0
C  parts of the 10 peak periods as defined by DRCOG - VMT from ALL classes 
C is included in diurnal distrubition
C****
C**** this do is a loop that terminates at the end of the program
C**** after the scenario files are written; Longmont only has urban
C**** suburban and rural areatypes
 	do ia = 3,5
C zero out accumulating variables
 	do ihr = 1,24
 	    vmtot(ihr) = 0.0
 	end do
 	daytot = 0		! VMT sum of entire day as f(fc)
 	do ifc = 1,8
 	if(speed(ifc,ia,1).gt.0) then
C
C	2. Construct the 24 hour vmt values by putting the correct 'halfs'
C	together
C
 	do ihr = 1,24
C identify the peak period that the first and second half hour belong to
C this variable is used with the for the VMT array. The halfs variable 
C needs to use the 1-48 numbers to identify the half hour it belongs to
 	    ifirst = ihalfs(ihr*2-1)
 	    isecond = ihalfs(ihr*2)
 	    vmthr(ifc,ia,ihr) = vmt(ifc,ia,ifirst)*halfs(ihr*2-1) + 
     x 	    	vmt(ifc,ia,isecond)*halfs(ihr*2)
 	    daytot = daytot + vmthr(ifc,ia,ihr)
 	    vmtot(ihr) = vmtot(ihr) +  vmthr(ifc,ia,ihr)
CP 	    print 72,ihr,ifirst,vmt(ifc,ia,ifirst),halfs(ihr*2-1),isecond,
CP     x		vmt(ifc,ia,isecond),halfs(ihr*2)
 	end do		! end for hour loop
 	end if 		! end if for speed conditional
 	end do		! end do for road class loop
 72	format(i3,2(i3,f10.0,f10.4))
C	3. Calculate the vmt hourly fractions calculations here; 
C	assuring that all 24 bins have values > 0.0; i.e., .0001 is minimum 
C	value allowed. 
	xadj = .0
C vmt weight the hourly vmts - five area type files result from calcs..
c	print *,daytot 
	do ihr = 1,24
	   vmtfrac(ihr) = vmtot(ihr)/daytot
c	   print 77,ihr,vmtot(ihr),vmtfrac(ihr)
 77	format(i5,f12.1,f10.4)
	   if(vmtfrac(ihr).lt..0001) then
	       vmtfrac(ihr) = .0001
	       xadj = xadj - .0001
	   end if
	end do
	vmtfrac(8) = vmtfrac(8) + xadj
CP	print *,daytot,xadj
C
C 	4. open VMT BY HOUR file and write file header  and VMT distribution
C
	close(2)
 	write(fnam,8)area(ia)
 	open(2,file=fnam)
 	write(2,7)
 	write(2,9)(vmtfrac(ihr),ihr=7,24),(vmtfrac(ihr),ihr=1,6)
C process the vmt for the VMT BY FACILITY files
	do ihr = 1,24
	    facvmt(1,ihr) = vmthr(1,ia,ihr) + vmthr(2,ia,ihr)
	    facvmt(2,ihr) = vmthr(3,ia,ihr) + vmthr(4,ia,ihr) 
     x		+ vmthr(5,ia,ihr)
	    facvmt(3,ihr) = vmthr(8,ia,ihr)
	    facvmt(4,ihr) = vmthr(6,ia,ihr)
	    tfvmt(ihr) = facvmt(1,ihr)+ facvmt(2,ihr)+ facvmt(3,ihr)
     x		+ facvmt(4,ihr)
CP            print 80,ihr,(facvmt(ifc,ihr),ifc=1,4),tfvmt(ihr)
 80	format(i5,5f10.1)
     	end do
     	do ihr = 1,24
     	   do ifc = 1,4
     	 	facvmt(ifc,ihr) = facvmt(ifc,ihr)/tfvmt(ihr)
     	   end do
     	end do
     	close(2)
 	write(fnam,18)area(ia)
 	open(2,file=fnam)
 	write(2,17)
 	do ivt = 1,28
 	    write(2,19)ivt,((facvmt(ifc,ihr),ifc=1,4),ihr=1,24)
 	end do
 	end do		! end do for areatype 
C
C	SPEED VMT files processing
C
C*********
C********
C  	2. SPEED VMT files for fwy-collector(1-5); no m6 speed input 
c 	for rmp & Local and no DRCOG VMT on frontage. VMT weight classes 1-2 
C 	(freeway) and 3-5 (arterials)
C 	Load hrspd vector with speeds averaged from the appropriate half hour
C 	period
 	do ia = 3,5
 	do ihr = 1,24	!assign speed half and sum the class VMT
 	  fwy_vmtot = 0.0
 	  if (ia.eq.1) then
 	    do ifc = 1,2	!fwy & exwy for cbd
 	      ifirst = ihalfs(ihr*2-1)
 	      isecond = ihalfs(ihr*2)
 	      hrspd(ifc,ihr) = speed(ifc,2,ifirst)/2. 
     x		+ speed(ifc,2,isecond)/2.
     	      fwy_vmtot = fwy_vmtot + vmthr(ifc,2,ihr)
     	    end do
     	    spdfc(1,ihr) = (hrspd(1,ihr)*vmthr(1,2,ihr) + 
     x		hrspd(2,ihr)*vmthr(2,2,ihr))/fwy_vmtot
	  else 	  
 	    do ifc = 1,2	! freeways and exy for frn-rur
 	      ifirst = ihalfs(ihr*2-1)
 	      isecond = ihalfs(ihr*2)
 	      hrspd(ifc,ihr) = speed(ifc,ia,ifirst)/2. 
     x		+ speed(ifc,ia,isecond)/2.
     	      fwy_vmtot = fwy_vmtot + vmthr(ifc,ia,ihr)
     	    end do        ! end for fwy-exy loop
C VMT weight the two classes
	  if(fwy_vmtot.eq.0) print *,' fwy_vmtot = ',fwy_vmtot
     	  spdfc(1,ihr) = (hrspd(1,ihr)*vmthr(1,ia,ihr) + 
     x		hrspd(2,ihr)*vmthr(2,ia,ihr))/fwy_vmtot
     	  end if
C repeat the above procedure for classes 3-5
 	  art_vmtot = 0.0
 	  do ifc = 3,5	!  arterials
 	      ifirst = ihalfs(ihr*2-1)
 	      isecond = ihalfs(ihr*2)
 	      hrspd(ifc,ihr) = speed(ifc,ia,ifirst)/2. 
     x		+ speed(ifc,ia,isecond)/2.
     	      art_vmtot = art_vmtot + vmthr(ifc,ia,ihr)
     	  end do        ! end for arterial loop
C VMT weight the three classes
     	  spdfc(2,ihr) = (hrspd(3,ihr)*vmthr(3,ia,ihr) + 
     x		 hrspd(4,ihr)*vmthr(4,ia,ihr) +
     x		 hrspd(5,ihr)*vmthr(5,ia,ihr))/art_vmtot
  	  print 78, ihr,hrspd(1,ihr),hrspd(2,ihr)
 78	format(' Fwy and Art speeds',i5,2f10.1)
  	end do	! hour loop


 71	format(2i3,f5.1,i3,2f5.1)
C	print 3,(hrspd(ifc,ia,ihr),ihr=1,24)
 3	format(6f5.1)
C open speed file and write file header on speed file
	write(fnam,5)area(ia)
 	close(1)
 	open(1,file=fnam)
	write(1,6)
 	do ifc = 1,2
C	assign speed bins for each hour
	do ihr=1,24
C zero out the bin fractions
	do i = 1,14
	    binfrac(ihr,i) = 0
	end do
C find the bin levels for given speed
	if(spdfc(ifc,ihr).gt.65.) spdfc(ifc,ihr)=65.
	do i = 1,14
	    if (spdbin(i).ge.spdfc(ifc,ihr)) go to 1
	end do
 1	xll = spdbin(i-1)
 	xul = spdbin(i)
 	binfrac(ihr,i-1) = (spdfc(ifc,ihr) - xul) / (xll - xul)
 	binfrac(ihr,i) = 1. - binfrac(ihr,i-1)
 50	format(f5.1,2f7.4) 
 	end do	!end for hour loop
C write the 6 am - midnight speeds; hours 6-25 (index 7-24)
	do i = 1,18
  	write(1,4)ifc,i,(binfrac(i+6,k),k=1,14)
        end do 	! end for   
C write the 1 am - 6 am speeds; hours 1-6 (index 1-6)
	do i = 19,24
  	write(1,4)ifc,i,(binfrac(i-18,k),k=1,14)
  	end do	! end for 1 am - 5 am
  	end do	! end for freeway and arterial speed array writes
C write scenario header record
	write(8,21)area(ia),AYR,VERSION
 21	FORMAT('SCENARIO REC       : DRCOG ',2X,A3,2X,A4,A2)
C write calendar year record
 	WRITE(8,22)ayr
 22	format('CALENDAR YEAR      : ',a4)
C write altitude record
	write(8,23)
 23	format('ALTITUDE           : 2')
C write speed vmt record 
	write(8,24)area(ia)
 24	format('SPEED VMT          : speed\',1a3,'.def')
C write vmt by hour file
	write(8,25)area(ia)
 25	format('VMT BY HOUR        : vmt\',1a3,'.def')
C write vmt by facility record
 	write(8,26)area(ia)
 26	format('VMT BY FACILITY    : facvmt\',a3,'.def')
C write read and write the  vmt fractions
	write(8,27)(vehmix(ia,j),j=1,16)
 27	format('VMT FRACTIONS      : ',2(/8(f6.4,x)))
C add the evaluation month for the summer factors
C write a blank line to separate the scenarios
 	write(8,70)
 	end do	! end for areatypes
C format statements
 9	format(4x,6f8.4)
 8	format('vmt\',1a3,'.def')
 7	format('VMT BY HOUR')
 4	format(i1,x,i2,14f7.4)
 5	format('speed\',1a3,'.def')
 6	format('SPEED VMT')
 18	format('facvmt\',1a3,'.def')
 17	format('VMT BY FACILITY')
 19	FORMAT(I2,F8.3,3F10.3,/,23(4f10.3/))
 20	format(4f10.3)
70	format(a)
  	end